@extends('user')
@section('content')

    <!-- domain begin-->
    <div class="domain" id="head_domain" style="padding-top:250px;padding-bottom:120px;">
        <div class="container">
            <div class="row mt-5">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header text-center text-white">
                            <h4>  {{ $exchange->send_method->name }} <i class="fa fa-sync "></i> {{ $exchange->receive_method->name }}</h4>
                        </div>
                        <div class="card-body">
                            <p class="card-text"> {{__($basic->exchange_confirm_text)}} </p>
                            <table class="table table-striped text-center">
                                <tbody>
                                <tr>
                                    <td> @lang('Exchange ID') </td>
                                    <td>{{ $exchange->trx}}</td>
                                </tr>
                                <tr>
                                    <td> @lang('Amount send')
                                        <br>
                                        <code>({{$exchange->send_method->name}})</code>
                                    </td>
                                    <td>{{ $exchange->send_amount }}</td>
                                </tr>
                                <tr>
                                    <td> @lang('Amount receive') <br>
                                        <code>({{$exchange->receive_method->name}})</code></td>
                                    <td>{{ $exchange->receive_amount}}</td>
                                </tr>
                                <tr>
                                    <td>{{ $exchange->receive_method->name }} <strong>@lang('Fee')</strong></td>
                                    <td> {{ $exchange->receive_amount_charge}} </td>
                                </tr>

                                <tr>
                                    <td> @lang('Total For Payment') </td>
                                    <td> {{ $exchange->send_amount + $exchange->send_amount_charge}} </td>
                                </tr>

                                </tbody>
                            </table>
                        </div>




                    </div>
                </div>
                <div class="col-md-12">



                    <div class="card mt-4">
                        <div class="card-body">
                            <form action="{{route('preview.info.ok')}}" method="POST">
                                @csrf

                                <div class="row">
                                    <div class="col-xl-12 col-lg-12">
                                        <div class="form-group">
                                            <label for="email"><strong> @lang('Your Email')</strong> </label>
                                            <input type="email" name="user_email" value="{{Auth::user()->email}}" class="form-control form-control-lg">
                                        </div>
                                    </div>

                                    <div class="col-xl-12 col-lg-12">
                                        <div class="form-group">
                                            <label for="method_email"><strong> {{$exchange->receive_method->name}} @lang('Account')</strong></label>
                                            <input type="text" class="form-control form-control-lg" name="receive_wallet_info">
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6">
                                        <div class="form-group">
                                            <a href="{{url('/')}}" class="btn btn-danger btn-block"><i class="fa fa-times"></i> @lang('Cancel Order') </a>
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6">

                                        <div class=" form-group">
                                            <button type="submit" class="btn btn-success btn-block"><i class="fa fa-check"></i> @lang('Confirm Order')</button>
                                        </div>
                                    </div>

                                </div>
                            </form>

                        </div>
                    </div>








                </div>

            </div>
        </div>
    </div>
    <!-- domain end -->

@endsection
